using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

namespace gov.va.med.vbecs.GUI
{
	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Margaret Jablonski</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>8/13/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary></summary>
	public class DlgTransfusionComplicationDetails : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Variables

		private BOL.TransfusionComplicationsReport _report;

		#endregion

		#region Form Controls
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox grpTransfusionDateRange;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.Label lblTransfusionEndDate;
		private System.Windows.Forms.Label lblTransfusionStartDate;
		private System.Windows.Forms.TextBox txtTransfusionStartDate;
		private System.Windows.Forms.TextBox txtTransfusionEndDate;
		private System.Windows.Forms.GroupBox grpReportCompilation;
		private System.Windows.Forms.RadioButton rdoScheduleJob;
		private System.Windows.Forms.RadioButton rdoCreateNow;
		private System.Windows.Forms.GroupBox grpScheduleJob;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbPrinterName;
		private System.Windows.Forms.Label lblPrinterName;
		private System.Windows.Forms.Label lblPrintDate;
		private System.Windows.Forms.DateTimePicker dtpPrintDate;
		private System.Windows.Forms.GroupBox grpDateRange;
		private System.Windows.Forms.DateTimePicker dtpEndDate;
		private System.Windows.Forms.Label lblEndDate;
		private System.Windows.Forms.Label lblStartDate;
		private System.Windows.Forms.DateTimePicker dtpStartDate;
		private System.ComponentModel.IContainer components = null;

		#endregion

		#region Constructors/Dispose

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgTransfusionComplicationDetails()
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			this._report = new BOL.TransfusionComplicationsReport();
			this._report.Valid += new System.EventHandler(this.CheckValid);
			this._report.Invalid += new System.EventHandler(this.CheckValid);
			this._report.IsDirtyChanged += new System.EventHandler(this.CheckValid);
			this._report.SetInitialBrokenRules(this.Name);
			SetComponentProperties();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgTransfusionComplicationDetails));
			this.grpTransfusionDateRange = new System.Windows.Forms.GroupBox();
			this.txtTransfusionEndDate = new System.Windows.Forms.TextBox();
			this.txtTransfusionStartDate = new System.Windows.Forms.TextBox();
			this.lblTransfusionEndDate = new System.Windows.Forms.Label();
			this.lblTransfusionStartDate = new System.Windows.Forms.Label();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.grpReportCompilation = new System.Windows.Forms.GroupBox();
			this.rdoScheduleJob = new System.Windows.Forms.RadioButton();
			this.rdoCreateNow = new System.Windows.Forms.RadioButton();
			this.grpScheduleJob = new System.Windows.Forms.GroupBox();
			this.cmbPrinterName = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblPrinterName = new System.Windows.Forms.Label();
			this.lblPrintDate = new System.Windows.Forms.Label();
			this.dtpPrintDate = new System.Windows.Forms.DateTimePicker();
			this.grpDateRange = new System.Windows.Forms.GroupBox();
			this.dtpEndDate = new System.Windows.Forms.DateTimePicker();
			this.lblEndDate = new System.Windows.Forms.Label();
			this.lblStartDate = new System.Windows.Forms.Label();
			this.dtpStartDate = new System.Windows.Forms.DateTimePicker();
			this.grpTransfusionDateRange.SuspendLayout();
			this.grpImage.SuspendLayout();
			this.grpReportCompilation.SuspendLayout();
			this.grpScheduleJob.SuspendLayout();
			this.grpDateRange.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(392, 30);
			this.vbecsLogo1.TabIndex = 5;
			this.vbecsLogo1.Title = "Transfusion Complications Report";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 281);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 7;
			// 
			// grpTransfusionDateRange
			// 
			this.grpTransfusionDateRange.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpTransfusionDateRange.Controls.Add(this.txtTransfusionEndDate);
			this.grpTransfusionDateRange.Controls.Add(this.txtTransfusionStartDate);
			this.grpTransfusionDateRange.Controls.Add(this.lblTransfusionEndDate);
			this.grpTransfusionDateRange.Controls.Add(this.lblTransfusionStartDate);
			this.grpTransfusionDateRange.Location = new System.Drawing.Point(60, 88);
			this.grpTransfusionDateRange.Name = "grpTransfusionDateRange";
			this.grpTransfusionDateRange.Size = new System.Drawing.Size(328, 48);
			this.grpTransfusionDateRange.TabIndex = 1;
			this.grpTransfusionDateRange.TabStop = false;
			this.grpTransfusionDateRange.Text = "Patient Transfusion Date Range Included";
			// 
			// txtTransfusionEndDate
			// 
			this.txtTransfusionEndDate.Location = new System.Drawing.Point(228, 20);
			this.txtTransfusionEndDate.Name = "txtTransfusionEndDate";
			this.txtTransfusionEndDate.ReadOnly = true;
			this.txtTransfusionEndDate.Size = new System.Drawing.Size(88, 20);
			this.txtTransfusionEndDate.TabIndex = 3;
			this.txtTransfusionEndDate.TabStop = false;
			this.txtTransfusionEndDate.Text = "";
			// 
			// txtTransfusionStartDate
			// 
			this.txtTransfusionStartDate.Location = new System.Drawing.Point(68, 20);
			this.txtTransfusionStartDate.Name = "txtTransfusionStartDate";
			this.txtTransfusionStartDate.ReadOnly = true;
			this.txtTransfusionStartDate.Size = new System.Drawing.Size(88, 20);
			this.txtTransfusionStartDate.TabIndex = 1;
			this.txtTransfusionStartDate.TabStop = false;
			this.txtTransfusionStartDate.Text = "";
			// 
			// lblTransfusionEndDate
			// 
			this.lblTransfusionEndDate.Location = new System.Drawing.Point(176, 20);
			this.lblTransfusionEndDate.Name = "lblTransfusionEndDate";
			this.lblTransfusionEndDate.Size = new System.Drawing.Size(60, 20);
			this.lblTransfusionEndDate.TabIndex = 2;
			this.lblTransfusionEndDate.Text = "End Date";
			this.lblTransfusionEndDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblTransfusionStartDate
			// 
			this.lblTransfusionStartDate.Location = new System.Drawing.Point(8, 20);
			this.lblTransfusionStartDate.Name = "lblTransfusionStartDate";
			this.lblTransfusionStartDate.Size = new System.Drawing.Size(60, 20);
			this.lblTransfusionStartDate.TabIndex = 0;
			this.lblTransfusionStartDate.Text = "Start Date";
			this.lblTransfusionStartDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(234, 265);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 3;
			this.btnOK.Click += new System.EventHandler(this.ClickOK);
			this.btnOK.MouseHover += new System.EventHandler(this.btnOK_MouseHover);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.CausesValidation = false;
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnCancel.Location = new System.Drawing.Point(314, 265);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 4;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 229);
			this.grpImage.TabIndex = 6;
			this.grpImage.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 45);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 0;
			this.pictureBox1.TabStop = false;
			// 
			// grpReportCompilation
			// 
			this.grpReportCompilation.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpReportCompilation.Controls.Add(this.rdoScheduleJob);
			this.grpReportCompilation.Controls.Add(this.rdoCreateNow);
			this.grpReportCompilation.Controls.Add(this.grpScheduleJob);
			this.grpReportCompilation.Location = new System.Drawing.Point(60, 140);
			this.grpReportCompilation.Name = "grpReportCompilation";
			this.grpReportCompilation.Size = new System.Drawing.Size(328, 120);
			this.grpReportCompilation.TabIndex = 2;
			this.grpReportCompilation.TabStop = false;
			this.grpReportCompilation.Text = "Report Compilation*";
			// 
			// rdoScheduleJob
			// 
			this.rdoScheduleJob.Location = new System.Drawing.Point(16, 40);
			this.rdoScheduleJob.Name = "rdoScheduleJob";
			this.rdoScheduleJob.Size = new System.Drawing.Size(120, 16);
			this.rdoScheduleJob.TabIndex = 1;
			this.rdoScheduleJob.Text = "&Schedule Print Job";
			this.rdoScheduleJob.CheckedChanged += new System.EventHandler(this.ReportCompilationChanged);
			// 
			// rdoCreateNow
			// 
			this.rdoCreateNow.Checked = true;
			this.rdoCreateNow.Location = new System.Drawing.Point(16, 20);
			this.rdoCreateNow.Name = "rdoCreateNow";
			this.rdoCreateNow.Size = new System.Drawing.Size(124, 16);
			this.rdoCreateNow.TabIndex = 0;
			this.rdoCreateNow.TabStop = true;
			this.rdoCreateNow.Text = "Create Report &Now";
			this.rdoCreateNow.CheckedChanged += new System.EventHandler(this.ReportCompilationChanged);
			// 
			// grpScheduleJob
			// 
			this.grpScheduleJob.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpScheduleJob.Controls.Add(this.cmbPrinterName);
			this.grpScheduleJob.Controls.Add(this.lblPrinterName);
			this.grpScheduleJob.Controls.Add(this.lblPrintDate);
			this.grpScheduleJob.Controls.Add(this.dtpPrintDate);
			this.grpScheduleJob.Enabled = false;
			this.grpScheduleJob.Location = new System.Drawing.Point(8, 40);
			this.grpScheduleJob.Name = "grpScheduleJob";
			this.grpScheduleJob.Size = new System.Drawing.Size(312, 72);
			this.grpScheduleJob.TabIndex = 2;
			this.grpScheduleJob.TabStop = false;
			// 
			// cmbPrinterName
			// 
			this.cmbPrinterName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbPrinterName.Interval = 500;
			this.cmbPrinterName.Location = new System.Drawing.Point(96, 44);
			this.cmbPrinterName.MaxLength = 50;
			this.cmbPrinterName.Name = "cmbPrinterName";
			this.cmbPrinterName.Size = new System.Drawing.Size(208, 22);
			this.cmbPrinterName.TabIndex = 3;
			this.cmbPrinterName.SelectedIndexChanged += new System.EventHandler(this.cmbPrinterName_SelectedIndexChanged);
			// 
			// lblPrinterName
			// 
			this.lblPrinterName.Location = new System.Drawing.Point(24, 44);
			this.lblPrinterName.Name = "lblPrinterName";
			this.lblPrinterName.Size = new System.Drawing.Size(76, 20);
			this.lblPrinterName.TabIndex = 2;
			this.lblPrinterName.Text = "Printer Name*";
			this.lblPrinterName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblPrintDate
			// 
			this.lblPrintDate.Location = new System.Drawing.Point(24, 20);
			this.lblPrintDate.Name = "lblPrintDate";
			this.lblPrintDate.Size = new System.Drawing.Size(72, 20);
			this.lblPrintDate.TabIndex = 0;
			this.lblPrintDate.Text = "Print Date*";
			this.lblPrintDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// dtpPrintDate
			// 
			this.dtpPrintDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpPrintDate.CalendarFont = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpPrintDate.CustomFormat = "MM/dd/yyyy hh:mm";
			this.dtpPrintDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpPrintDate.Location = new System.Drawing.Point(96, 20);
			this.dtpPrintDate.Name = "dtpPrintDate";
			this.dtpPrintDate.Size = new System.Drawing.Size(208, 20);
			this.dtpPrintDate.TabIndex = 1;
			this.dtpPrintDate.Value = new System.DateTime(2003, 6, 20, 15, 24, 4, 467);
			this.dtpPrintDate.ValueChanged += new System.EventHandler(this.dtpPrintDate_ValueChanged);
			// 
			// grpDateRange
			// 
			this.grpDateRange.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpDateRange.Controls.Add(this.dtpEndDate);
			this.grpDateRange.Controls.Add(this.lblEndDate);
			this.grpDateRange.Controls.Add(this.lblStartDate);
			this.grpDateRange.Controls.Add(this.dtpStartDate);
			this.grpDateRange.Location = new System.Drawing.Point(60, 32);
			this.grpDateRange.Name = "grpDateRange";
			this.grpDateRange.Size = new System.Drawing.Size(328, 52);
			this.grpDateRange.TabIndex = 0;
			this.grpDateRange.TabStop = false;
			this.grpDateRange.Text = "Report Date Range";
			// 
			// dtpEndDate
			// 
			this.dtpEndDate.CalendarFont = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpEndDate.CustomFormat = "MM/dd/yyyy";
			this.dtpEndDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpEndDate.Location = new System.Drawing.Point(224, 20);
			this.dtpEndDate.Name = "dtpEndDate";
			this.dtpEndDate.Size = new System.Drawing.Size(88, 20);
			this.dtpEndDate.TabIndex = 3;
			this.dtpEndDate.Value = new System.DateTime(2100, 1, 1, 23, 59, 0, 0);
			this.dtpEndDate.ValueChanged += new System.EventHandler(this.dtpEndDate_ValueChanged);
			// 
			// lblEndDate
			// 
			this.lblEndDate.Location = new System.Drawing.Point(172, 20);
			this.lblEndDate.Name = "lblEndDate";
			this.lblEndDate.Size = new System.Drawing.Size(56, 20);
			this.lblEndDate.TabIndex = 2;
			this.lblEndDate.Text = "End Date*";
			this.lblEndDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblStartDate
			// 
			this.lblStartDate.Location = new System.Drawing.Point(8, 20);
			this.lblStartDate.Name = "lblStartDate";
			this.lblStartDate.Size = new System.Drawing.Size(60, 20);
			this.lblStartDate.TabIndex = 0;
			this.lblStartDate.Text = "Start Date*";
			this.lblStartDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// dtpStartDate
			// 
			this.dtpStartDate.CalendarFont = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpStartDate.CustomFormat = "MM/dd/yyyy";
			this.dtpStartDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpStartDate.Location = new System.Drawing.Point(68, 20);
			this.dtpStartDate.Name = "dtpStartDate";
			this.dtpStartDate.Size = new System.Drawing.Size(88, 20);
			this.dtpStartDate.TabIndex = 1;
			this.dtpStartDate.Value = new System.DateTime(1900, 1, 1, 0, 0, 0, 0);
			this.dtpStartDate.ValueChanged += new System.EventHandler(this.dtpStartDate_ValueChanged);
			// 
			// DlgTransfusionComplicationDetails
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(392, 297);
			this.Controls.Add(this.grpDateRange);
			this.Controls.Add(this.grpReportCompilation);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.grpTransfusionDateRange);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.btnCancel);
			this.hlphelpChm.SetHelpKeyword(this, "Transfusion_Complications_Report.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(400, 324);
			this.Name = "DlgTransfusionComplicationDetails";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Transfusion Complications Report";
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.grpTransfusionDateRange, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.grpReportCompilation, 0);
			this.Controls.SetChildIndex(this.grpDateRange, 0);
			this.grpTransfusionDateRange.ResumeLayout(false);
			this.grpImage.ResumeLayout(false);
			this.grpReportCompilation.ResumeLayout(false);
			this.grpScheduleJob.ResumeLayout(false);
			this.grpDateRange.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Properties
		/// <summary>
		/// Gets VBECS report object
		/// </summary>
		public BOL.TransfusionComplicationsReport TransfusionComplicationReport
		{
			get
			{
				return this._report;
			}
		}
		#endregion
		
		#region Methods

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC090.DlgTransfusionComplicationDetails());
			//
			this.btnOK.Text = "&OK";
			//
			this.dtpStartDate.CustomFormat = Common.VBECSDateTime.DateFormat;
			this.dtpEndDate.CustomFormat = Common.VBECSDateTime.DateFormat;
			this.dtpPrintDate.CustomFormat = Common.VBECSDateTime.DateTimeFormat;
	
			//set current date value based on the division time zone
			System.DateTime currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			//BR_77.01
			this.dtpStartDate.Value = this._report.StartDate;
			this.dtpEndDate.Value = this._report.EndDate;
			this.dtpPrintDate.Value = currentDate;

			LoadPrinters();
		}

		private void CheckValid(object sender, System.EventArgs e)
		{
			this.btnOK.EnabledButton = (this._report.IsValid);
		}

		private void CheckDates()
		{
			if (this._report.StartDate > this._report.EndDate)
			{
				this.errError.SetVbecsError(this.dtpEndDate, Common.StrRes.SysErrMsg.Common.CannotbeGreaterError("Start date","End date").ResString); // **** 508 Compliance ***
			}
			else
			{
				this.errError.SetVbecsError(this.dtpEndDate, ""); // **** 508 Compliance ***
			}
			//
			if (this._report.IsScheduled)
			{
				if (this._report.EndDate > this._report.PrintDate)
				{
					this.errError.SetVbecsError(this.dtpPrintDate, Common.StrRes.SysErrMsg.Common.CannotbeLessError("Print date","End date").ResString); // **** 508 Compliance ***
				}
				else
				{
					this.errError.SetVbecsError(this.dtpPrintDate, ""); // **** 508 Compliance ***
				}
			}
			else
			{
				this.errError.SetVbecsError(this.dtpPrintDate, ""); // **** 508 Compliance ***
			}
		}

		private void LoadPrinters()
		{
			this.cmbPrinterName.Items.Clear();
			//
			foreach (string printerName in BOL.VbecsReport.GetPrinters())
			{
				cmbPrinterName.Items.Add(printerName);
			}
		}


		#endregion

		#region Events / Event Handlers

		private void dtpStartDate_ValueChanged(object sender, System.EventArgs e)
		{
			this._report.StartDate = this.dtpStartDate.Value;
			this._report.TransfusionStartDate = this.dtpStartDate.Value.AddMonths(-12);
			this.txtTransfusionStartDate.Text = Common.VBECSDateTime.FormatDateString(this._report.TransfusionStartDate);
			CheckDates();
		}

		private void dtpEndDate_ValueChanged(object sender, System.EventArgs e)
		{
			this._report.EndDate = this.dtpEndDate.Value;
			this._report.TransfusionEndDate = this.dtpEndDate.Value;
			this.txtTransfusionEndDate.Text = Common.VBECSDateTime.FormatDateString(this._report.TransfusionEndDate); 
			CheckDates();
		}

		private void dtpPrintDate_ValueChanged(object sender, System.EventArgs e)
		{
			if (this._report.IsScheduled)
			{
				this._report.PrintDate = this.dtpPrintDate.Value;
			}
			CheckDates();
		}

		private void cmbPrinterName_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (this._report.IsScheduled)
			{
				if(cmbPrinterName.SelectedItem!=null)
				{
					string printer=this.cmbPrinterName.Text;
					for(int i=0; i<this.cmbPrinterName.Items.Count; i++)
					{
						if(printer==this.cmbPrinterName.Items[i].ToString())
						{
							this._report.PrinterName = cmbPrinterName.SelectedItem.ToString();
						}
					}
				}		
				else
				{
					this._report.PrinterName=String.Empty;
				}
//				if (this.cmbPrinterName.SelectedIndex > -1)
//				{
//					this._report.PrinterName = this.cmbPrinterName.Text;
//				}
//				else
//				{
//					this._report.PrinterName = "";
//				}
			}
		}

		private void ClickOK(object sender, System.EventArgs e)
		{
			if (this._report.IsScheduled)
			{
				if (this._report.IsScheduledReportGreaterThanThirtyDays)
				{
					if (DialogResult.Yes != GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.ScheduledReportGreaterThanThirtyDays()))
					{
						return;
					}
				}
				//
				try
				{
					this._report.Schedule();
					//
					this.DialogResult = DialogResult.Cancel;
				}
				catch(BOL.BusinessObjectException)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.ScheduleReportFailed());
					return;
				}
			}
			else
			{
				int count = 0;
				//
				BOL.LabTest labTest = new BOL.LabTest();
				labTest.ReportType = Common.ReportType.TransfusionComplication;
				System.Data.DataRow[] labTests = labTest.GetLabTests().Select(Common.VbecsTables.SpecimenTestThreshold.RecordStatusCode+" = '"+Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active)+"'");
				//
				if (labTests.Length>0)
				{
					count = BOL.PatientTransfusion.GetTransfusedUnitsInDateRangeCount(this._report.TransfusionStartDate, this._report.TransfusionEndDate);
				}
				//
				if(count==0)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC049.NoInfoReturned());
					return;
				}
				else if(count>=50)
				{
					DialogResult _result = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC049.PageCountAlert());
					if( _result != DialogResult.Yes )
					{
						return;
					}
					else
					{
						//Alert user that building report may take a few minutes
						GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC049.Warning());
					}
				}
				//
				this.DialogResult = DialogResult.OK;
			}
			//
			this.Close();
		}

		private void btnOK_MouseHover(object sender, System.EventArgs e)
		{
			if (this._report.IsValid)
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToContinue().ResString);
			}
			else
			{
				this.btnOK.SetToolTip(this._report.GetBrokenRulesMessage(this.Name));
			}

		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void ReportCompilationChanged(object sender, System.EventArgs e)
		{
			this._report.IsScheduled = (this.rdoScheduleJob.Checked);
			this.grpScheduleJob.Enabled = (this.rdoScheduleJob.Checked);
			//Set it only if enabled
			if(this.grpScheduleJob.Enabled)
			{
				if (this._report.PrintDate == DateTime.MinValue)
				{
					this.dtpPrintDate.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
				}
			}
		}
		
		#endregion

	}
}

